<?php
add_action( 'widgets_init', 'wp_posts_slider_widget' );
function wp_posts_slider_widget() {
	register_widget( 'wp_posts_slider_widget' );
}

class wp_posts_slider_widget extends WP_Widget {

	public function __construct(){
		$widget_ops = array( 'classname' => 'wp_posts_slider_widget' ,'description' => ' سایدبار اصلی' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'wp_posts_slider_widget' );
		parent::__construct( 'wp_posts_slider_widget',''. __( 'News - اسلایدر اصلی تمام عرض' , 'wp'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );


		$title     = $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
		$category  = $instance['category'];
		$number    = $instance['number'];
?>
		<div id="flexslider" class="flexslider">
		<ul class="slides">
	<?php
    $my_query = new WP_Query('showposts='.$number.'&cat='.$category);
    while ($my_query->have_posts()):  $my_query->the_post(); ?>			
		<li>
		<div class="slider-big">
                 <?php if(has_post_thumbnail()){?><a href="<?php the_permalink(); ?>"><?php $ata = get_the_title(); if ( has_post_thumbnail()) the_post_thumbnail('img-650', array('title' => esc_attr( $post->post_title ) , 'alt' => $ata ) ); ?></a><?php }else{ ?><img src="<?php bloginfo("template_url"); ?>/img/none.png"><?php } ?>
		<div class="slider-caption">
		<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		<p><?php if(get_meta('lead') != false) : echo get_meta('lead'); else : the_excerpt(); endif; ?></p></div>
		</div>
		</li>
	<?php endwhile; ?>
    <?php wp_reset_query(); ?>					
	</ul>
	</div>		
<script>
jQuery(document).ready(function() {
  jQuery('#flexslider').flexslider({
    animation: "fade",	slideshowSpeed: 7000,
	animationSpeed: 600,
	randomize: false,
	prevText: "",
	nextText: "",
	after: function(slider) {
		jQuery('#flexslider .slider-caption').animate({bottom:0,}, 400)
	},
	before: function(slider) {
		jQuery('#flexslider .slider-caption').animate({ bottom:-105,}, 400)
	},
	pauseOnHover: true
  });
});
</script>	

       	<?php 
	}

	function update( $new_instance, $old_instance ) {
		$instance              = $old_instance;
		$instance['title']     = wp_strip_all_tags( $new_instance['title'] );
		$instance['category']  = wp_strip_all_tags( $new_instance['category'] );
		$instance['number']    = is_numeric( $new_instance['number'] ) ? intval( $new_instance['number'] ) : 5;

		return $instance;
	}

	function form( $instance ) {
		$defaults  = array( 'title' => '', 'category' => '', 'number' => 6, 'show_date' => '' );
		$instance  = wp_parse_args( ( array ) $instance, $defaults );
		$title     = $instance['title'];
		$category  = $instance['category'];
		$number    = $instance['number'];
		
		?>
		
        <p><em style="color:#0073aa;"><?php echo 'توجه : '; ?></em></p>
		<p><em style="color:#0085ba;"><?php echo 'این ابزارک فقط یک مرتبه باید به کار گرفته شود.'; ?></em></p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e( 'انتخاب دسته' ); ?>:</label>				
			
			<?php

			wp_dropdown_categories( array(

				'orderby'    => 'title',
				'hide_empty' => false,
				'name'       => $this->get_field_name( 'category' ),
				'id'         => $this->get_field_id( 'category' ),
				'class'      => 'widefat',
				'selected'   => $category

			) );

			?>

		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'تعداد مطالب' ); ?>: </label>
			<input type="text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo esc_attr( $number ); ?>" size="3" />
		</p>

		
		
		<?php
	
	}
}
?>